#include <CtrlLib/CtrlLib.h>
#include <Web/Web.h>

using namespace Upp;

#define LAYOUTFILE <P2PSocket/P2PSocket.lay>
#include <CtrlCore/lay.h>

class  SocketApp : public WithMainLay<TopWindow> {
	Socket sock;
public:
	void SSwitch();
	void SSend();
	typedef   SocketApp CLASSNAME;
	SocketApp();
};


void SocketApp::SSwitch()
{
	if (ssw==0) {
		sock.Close();
//		PromptOK("4662 socket server CLOSED. You can check it with nmap command");
	}
	else if (ssw==1) {
		ServerSocket(sock, 4662, true, 5, false);
		
//		sock.Linger(int msecs)
//		sock.Write("hello from 4662\n\n");
//		PromptOK("4662 socket server OPENED. You can check it with nmap command");
	}
	else	
		PromptOK("Warning: check your switch inits!");
}

void SocketApp::SSend()
{
	ssw=1;
	SSwitch();
	if (sock.IsOpen()) {
		;
//		sock.Clear();
//		sock.ClearError();
//		PromptOK("IsOpen() ok. +Error:?"+Socket::GetErrorText());

		sock.WriteWait( "hello\n", 6, 100); //("hello from 4662\n\n");
//		PromptOK("Written ok");		
//		sock.Write("hello from 4662\n\n");
	}
	else
		PromptOK("Sock not opened");		
}


SocketApp::SocketApp()
{
	CtrlLayout(*this, "P2PSocket Server");
	ssw.SetLabel(0, "STOP 4662");
	ssw.SetLabel(1, "START 4662");
	ssw=0;

	ssw.WhenAction = THISBACK(SSwitch);
	btn1.WhenAction = THISBACK(SSend);
	
	Sizeable().Zoomable();
}


GUI_APP_MAIN
{
	SocketApp().Run();
}

