/*
 *      Copyright (c) 2024 Scott Duensing, scott@duensing.com
 *
 *      Permission is hereby granted, free of charge, to any person obtaining a copy
 *      of this software and associated documentation files (the "Software"), to deal
 *      in the Software without restriction, including without limitation the rights
 *      to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *      copies of the Software, and to permit persons to whom the Software is
 *      furnished to do so, subject to the following conditions:
 *
 *      The above copyright notice and this permission notice shall be included in
 *      all copies or substantial portions of the Software.
 *
 *      THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *      IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *      FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *      AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *      LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *      OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *      SOFTWARE.
 */


#ifndef _StoreManager_StoreManager_h
#define _StoreManager_StoreManager_h


#include <CtrlLib/CtrlLib.h>
#include <Core/SSH/SSH.h>
#include <MySql/MySql.h>


using namespace Upp;


#define LAYOUTFILE <StoreManager/StoreManager.lay>
#include <CtrlCore/lay.h>


#define APP_NAME           "Store Manager"
#define CONFIG_FILE        "storemanager.cfg"

#define SSH_AUTH_KEY       "Key File"
#define SSH_AUTH_AGENT     "SSH Agent"

#define DB_CONN_HOST_PORT  "Host and Port"


class StoreManager : public WithStoreManagerLayout<TopWindow> {
	public:
		StoreManager();
		
	private:
		MenuBar      menu;
		SshSession   sshSession;
		MySqlSession sqlSession;

		class Config {
			public:
				Config();
				String GetConfigFile();
			    void   Jsonize(JsonIO& json);

				int    intUseSSH;    // This is actually a tri-state value.
				String strSSHServer;
				int    intSSHPort;
				String strSSHAuth;
				String strSSHUser;
				String strSSHPass;
				String strSSHPrivateKey;
				String strSSHPublicKey;

				String strDBConnection;
				String strDBServer;
				int    intDBPort;
				String strDBUser;
				String strDBPass;
				String strDBDatabase;
		};
		
		bool ConnectToDB(Config& config);
		void CopyDBSettingsToConfig(WithDatabaseSettingsLayout<TopWindow>& dialog, Config& config);
		void DisconnectFromDB(Config& config);
		void FileMenu(Bar& bar);
		void MainMenuBar(Bar& bar);
		void SettingsMenu(Bar& bar);
		void ShowDBSettings();
		void UpdateDBSettingsFields(WithDatabaseSettingsLayout<TopWindow>& dialog);
		
		Config settings;
};


#endif
