#include "testmt.h"

LocalProcess globalExecutor;
void* globalProcesID;

void ExecutableThread(Test* test, const String& file, bool newConsole) {
#ifdef PLATFORM_WIN32
	if (newConsole) {
		int n = file.GetLength() + 1;
		Buffer<char> cmd(n);
		memcpy(cmd, file, n);
		
		SECURITY_ATTRIBUTES sa;
		ZeroMemory(&sa, sizeof(SECURITY_ATTRIBUTES));
		sa.nLength = sizeof(SECURITY_ATTRIBUTES);
		sa.lpSecurityDescriptor = NULL;
		sa.bInheritHandle = TRUE;
		
		PROCESS_INFORMATION pi;
		ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
		
		STARTUPINFO si;
		ZeroMemory(&si, sizeof(STARTUPINFO));
		si.dwFlags = STARTF_USESHOWWINDOW;
		si.wShowWindow = SW_SHOW;
		si.cb = sizeof(STARTUPINFO);
		
		if (CreateProcess(NULL, cmd, &sa, &sa, TRUE,
			             NORMAL_PRIORITY_CLASS|CREATE_NEW_CONSOLE,
		                NULL, NULL, &si, &pi)) {
		    globalProcesID = (void*)pi.hProcess;
		    
		    WaitForSingleObject(pi.hProcess, INFINITE);
		                    
			CloseHandle(pi.hProcess);
			CloseHandle(pi.hThread);
			
			globalProcesID = nullptr;
		}
		else
			;//PutConsole("Unable to launch " + String(_cmdline));
	}
	else {
		
#endif

		String t, tt;
		
		globalExecutor.Kill();
		globalExecutor.ConvertCharset(false);
		globalExecutor.Start(file);
		
		while (globalExecutor.Read(t)) {
			if (t.GetCount()) {
				PostCallback(callback1(test, &Test::AddOutputLine, t));
			}
		}
		
#ifdef PLATFORM_WIN32
	}
#endif
	
	PostCallback(callback(test, &Test::OutPutEnd));
}

Test::Test()
{
	CtrlLayout(*this, "Window title");
	
	btnOk.WhenAction = THISBACK(OnAction);
}

void Test::OnAction() {
	Title("Executing");
	
	Thread().Run(callback3(ExecutableThread, this, "c:\\temp\\test.pak\\test4.exe", false));
}

void Test::AddOutputLine(const String& str) {
	console << str;
	console.ScrollEnd();
}

void Test::OutPutEnd() {
	Title("Execution done.");
}

GUI_APP_MAIN
{
	Test().Run();
}
