#ifndef _testmt_testmt_h
#define _testmt_testmt_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class Console: public LineEdit {
public:
	bool VerboseBuild = false;

	Console() {
		SetReadOnly();
	}

	Callback WhenLeft;

	virtual void LeftUp(Point p, dword flags) {
		LineEdit::LeftUp(p, flags);
		WhenLeft();
	}
	
	void ScrollLineUp() {
		sb.LineUp();
	}
	
	Console& operator<<(const String& s) {
		Append(s);
		return *this;
	}
	
	void Append(const String& s) {
		Insert(total, s);
	}
};

#define LAYOUTFILE <testmt/testmt.lay>
#include <CtrlCore/lay.h>

class Test: public WithLayout<TopWindow> {
public:
	typedef Test CLASSNAME;
	
	Test();
	
	void OnAction();
	void AddOutputLine(const String& str);
	void OutPutEnd();
};

#endif
