#!/usr/bin/env bash
set -euo pipefail

OPENSSL_VER=3.6.0

# Update and install prerequisites
sudo apt update
sudo apt install -y build-essential perl wget tar xz-utils clang llvm binutils-mingw-w64


# Get llvm-mingw toolchain (Linux x86_64 host build)
LLVM_MINGW_VER=20251202
LLVM_MINGW_TARBALL=llvm-mingw-${LLVM_MINGW_VER}-ucrt-ubuntu-22.04-x86_64.tar.xz
wget -O ${LLVM_MINGW_TARBALL} https://github.com/mstorsjo/llvm-mingw/releases/download/${LLVM_MINGW_VER}/${LLVM_MINGW_TARBALL}

sudo tar -xJf ${LLVM_MINGW_TARBALL} -C /opt
sudo mv /opt/llvm-mingw-${LLVM_MINGW_VER}-ucrt-ubuntu-22.04-x86_64 /opt/llvm-mingw

# Add llvm-mingw to PATH
export PATH=/opt/llvm-mingw/bin:$PATH

# Verify compilers
x86_64-w64-mingw32-clang --version
aarch64-w64-mingw32-clang --version

# Get OpenSSL source
wget https://www.openssl.org/source/openssl-${OPENSSL_VER}.tar.gz
tar xzf openssl-${OPENSSL_VER}.tar.gz
cd openssl-${OPENSSL_VER}

