#include "vCore.h"

V_NAMESPACE

Vec<RegUTestFunc::UTestEntry> *RegUTestFunc::tests = NULL;
int RegUTestFunc::failed = 0;
const char *RegUTestFunc::utest = "UTest";

RegUTestFunc::RegUTestFunc(const char *name, void (*dg)(const char *), int type) {
	if(!tests) {
		tests = new Vec<UTestEntry>;
	}
	tests->Add(UTestEntry(name, dg, type));
}

double RegUTestFunc::CallTest(const char *name, void (*dg)(const char *)) {
	Timer timer;
	try {
		dg(name);
	} catch(ErrorMsg e) {
		failed++;
		Err(utest, name, "ErrorMsg exception: " % e.GetErr() % "-" % e.GetMsg());
	} catch(Error) {
		failed++;
		Err(utest, name, "Error exception");
	} catch(...) {
		failed++;
		Err(utest, name, "Unknown exception");
	}
	return timer.GetTime();
}

void RegUTestFunc::Execute() {
	int n = 0;
	if(tests)
		n = tests->GetCount();
	if(n > 0) {
		double totalT = 0.0;
		Inf(utest, "*Begin*", "Executing unit tests...");
		foreach(const UTestEntry &test, *tests) {
			if(test.type == 1) {
				double t = CallTest(test.name, test.dg);
				totalT += t;
				Inf(utest, "*Init*", "Init of module: '" % test.name % "' took: " % t % " seconds");
			}
		}
		foreach(const UTestEntry &test, *tests) {
			if(test.type == 0) {
				double t = CallTest(test.name, test.dg);
				totalT += t;
				Inf(utest, test.name, "Execution took: " % t % " seconds");
			}
		}
		foreach(const UTestEntry &test, *tests) {
			if(test.type == -1) {
				double t = CallTest(test.name, test.dg);
				totalT += t;
				Inf(utest, "*Term*", "Term of module: '" % test.name % "' took: " % t % " seconds");
			}
		}			
		if(tests)
			delete tests;	
		if(failed) {
			Err("UTest", "*Summary*", failed % " from " % n % " unit tests failed! - Execution time: " % totalT % " seconds");
			Sleep(10000);
			exit(0);
		} else
			Inf("UTest", "*Summary*", "All " % n % " unit tests passed in: " % totalT % " seconds");
	}
}

bool RegUTestFunc::CheckTiming(const char *name, double s, double t) {
	if(t > s) {
		RegUTestFunc::failed++;
		Err(RegUTestFunc::utest, name, "Execution took more than: " % s % " seconds: (" % t % ")");		
	}
	return false;
}

END_NAMESPACE
