struct RegUTestFunc {
	struct UTestEntry : Moveable<UTestEntry> {
		String name;
		void (*dg)(const char *);
		int type;
		
		UTestEntry() {}
		UTestEntry(const char *_name, void (*_dg)(const char *), int _type) 
		: name(_name), dg(_dg), type(_type) {}
	};
	
	static Vec<UTestEntry> *tests;
	static int failed;
	static const char *utest;

	RegUTestFunc(const char *name, void (*dg)(const char *), int type);
	static double CallTest(const char *name, void (*dg)(const char *));
	static void Execute();
	static bool CheckTiming(const char *name, double s, double t);
};

#ifdef V_UTEST
	void inline RunUTests() { RegUTestFunc::Execute(); }
#else
	void inline RunUTests() {}
#endif

#define UModule(name) namespace name  

#define UTest(name) \
	void UTestFunc_##name(const char *_test); \
	RegUTestFunc UTest_##name(#name, UTestFunc_##name, 0); \
	void UTestFunc_##name(const char *_test)

#define UInit(name) \
	void UTestFunc_Init_##name(const char *_test); \
	RegUTestFunc UTest_Init_##name(#name, UTestFunc_Init_##name, 1); \
	void UTestFunc_Init_##name(const char *_test)

#define UTerm(name) \
	void UTestFunc_Term_##name(const char *_test); \
	RegUTestFunc UTest_Term_##name(#name, UTestFunc_Term_##name, -1); \
	void UTestFunc_Term_##name(const char *_test)
		
#define UCheck(v) \
	if(!(v)) { \
		RegUTestFunc::failed++; \
		Err(RegUTestFunc::utest, _test, "Failed: '" % #v % "' - " % __FILE__ % "[" % __LINE__ % "]"); \
	} 

#define UExcept(E, v) \
	bool MK__s = true; try { v; } catch(E) { MK__s = false; } \
	if(MK__s) { \
		RegUTestFunc::failed++; \
		Err(RegUTestFunc::utest, _test, \
		"Expected exception '" % #E % "' not thrown: '" % #v % "' - " % __FILE__ % "[" % __LINE__ % "]"); \
	}
	
#define UTiming(t) \
	if(bool _c_ = true) for(Timer _t_; _c_; _c_ = RegUTestFunc::CheckTiming(_test, t, _t_.GetTime())) 
