#include "vCore.h"

#ifdef V_UTEST

UTest(UTest) {
	UCheck(true);
	UExcept(int, throw 1);
	UTiming(0.1) {
		loop(1000);
	}
}

UModule(Iteration) {
	Vec<int> vec;

	UInit(Iteration) {
		vec.AddN(100000, 1);
	}
	
	UTest(Iteration) {
		int c = 0;
		loop(100) {
			Iter it = vec.Begin();
			Iter e = vec.End();
			for(; it < e; vec.Next(it)) {
				c += vec[it];
			}
		}
		UCheck(c == 10000000);
	}
	
	UTest(foreach) {
		int c = 0;
		loop(100) {
			foreach(int qq, vec) {
				c += qq;
			}		
		}
		UCheck(c == 10000000);
	}
}

UTest(FVec) {
	FVec<int, 64> v1;
	FVec<int, 64> v2;
	v1.AddN(3);
	v2.AddN(6);
	v1.Append(v2);
	v1.Remove(1, 3);
}

UTest(Vec) {
	Vec<int> v1;
	Vec<int> v2;
	v1.AddN(3);
	v2.AddN(6);
	v1.Append(v2);
	v1.Remove(1, 3);
	UCheck(v1.GetCount() == 6);
	v1.Shrink();
	UCheck(v1.GetAlloc() == 6);	
}

UTest(VecCOW) {
	VecCOW<int> v1;
	VecCOW<int> v2;
	v1.AddN(3);
	v2.AddN(6);
	v1.Append(v2);
	v1.Remove(1, 3);
	UCheck(v1.GetCount() == 6);
	v1.Shrink();
	UCheck(v1.GetAlloc() == 6);	
}

UTest(FVec_Vec_VecCOW) {
	FVec<int, 16> v1;
	Vec<int> v2;
	VecCOW<int> v3;
	VecCOW<int> v4;
	v2.AddN(3);
	v1 = v2;
	UCheck(v1.GetCount() == 3);
	v1.AddN(4);
	v2 = v1;
	UCheck(v2.GetCount() == 7);
	v3 = v2;
	UCheck(v2.IsNil());	
	v4 = v3;
	UCheck(!v3.IsNil());	
}

UTest(Map) {
	Map<int, int> map;
	int *v;
	
	int k = 1; map.GetAddPtr(k, v);
	k = 9; map.GetAddPtr(k, v);
	k = 2; map.GetAddPtr(k, v);

	UCheck(map.GetCount() == 3);

	foreach_key(int i, map) i;
	foreach_entry(int, int, e, map) e;
		
	k = 1; map.Remove(k);
	k = 9; map.Remove(k);
	k = 2; map.Remove(k);

	UCheck(map.GetCount() == 0);
}

#endif
