/* inflate.h -- internal inflate state definition
 * Copyright (C) 1995-2004 Mark Adler
 * For conditions of distribution and use, see copyright notice in zlib.h
 */

/* WARNING: this file should *not* be used by applications. It is
   part of the implementation of the compression library and is
   subject to change. Applications should only use zlib.h.
 */

#ifndef INFLATE_H
#define INFLATE_H

/* define NO_GZIP when compiling if you want to disable gzip header and
   trailer decoding by inflate().  NO_GZIP would be used to avoid linking in
   the crc code when it is not needed.  For shared libraries, gzip decoding
   should be left enabled. */
#ifndef NO_GZIP
#  define GUNZIP
#endif

/* Possible inflate modes between inflate() calls */
typedef enum {
    infHEAD,       /* i: waiting for magic header */
    infFLAGS,      /* i: waiting for method and flags (gzip) */
    infTIME,       /* i: waiting for modification time (gzip) */
    infOS,         /* i: waiting for extra flags and operating system (gzip) */
    infEXLEN,      /* i: waiting for extra length (gzip) */
    infEXTRA,      /* i: waiting for extra bytes (gzip) */
    infNAME,       /* i: waiting for end of file name (gzip) */
    infCOMMENT,    /* i: waiting for end of comment (gzip) */
    infHCRC,       /* i: waiting for header crc (gzip) */
    infDICTID,     /* i: waiting for dictionary check value */
    infDICT,       /* waiting for inflateSetDictionary() call */
        infTYPE,       /* i: waiting for type bits, including last-flag bit */
        infTYPEDO,     /* i: same, but skip check to exit inflate on new block */
        infSTORED,     /* i: waiting for stored size (length and complement) */
        infCOPY,       /* i/o: waiting for input or output to copy stored block */
        infTABLE,      /* i: waiting for dynamic block table lengths */
        infLENLENS,    /* i: waiting for code length code lengths */
        infCODELENS,   /* i: waiting for length/lit and distance code lengths */
            infLEN,        /* i: waiting for length/lit code */
            infLENEXT,     /* i: waiting for length extra bits */
            infDIST,       /* i: waiting for distance code */
            infDISTEXT,    /* i: waiting for distance extra bits */
            infMATCH,      /* o: waiting for output space to copy string */
            infLIT,        /* o: waiting for output space to write literal */
    infCHECK,      /* i: waiting for 32-bit check value */
    infLENGTH,     /* i: waiting for 32-bit length (gzip) */
    infDONE,       /* finished check, done -- remain here until reset */
    infBAD,        /* got a data error -- remain here until reset */
    infMEM,        /* got an inflate() memory error -- remain here until reset */
    infSYNC        /* looking for synchronization bytes to restart inflate() */
} inflate_mode;

/*
    State transitions between above modes -

    (most modes can go to the BAD or MEM mode -- not shown for clarity)

    Process header:
        HEAD -> (gzip) or (zlib)
        (gzip) -> FLAGS -> TIME -> OS -> EXLEN -> EXTRA -> NAME
        NAME -> COMMENT -> HCRC -> TYPE
        (zlib) -> DICTID or TYPE
        DICTID -> DICT -> TYPE
    Read deflate blocks:
            TYPE -> STORED or TABLE or LEN or CHECK
            STORED -> COPY -> TYPE
            TABLE -> LENLENS -> CODELENS -> LEN
    Read deflate codes:
                LEN -> LENEXT or LIT or TYPE
                LENEXT -> DIST -> DISTEXT -> MATCH -> LEN
                LIT -> LEN
    Process trailer:
        CHECK -> LENGTH -> DONE
 */

/* state maintained between inflate() calls.  Approximately 7K bytes. */
struct inflate_state {
    inflate_mode mode;          /* current inflate mode */
    int last;                   /* true if processing last block */
    int wrap;                   /* bit 0 true for zlib, bit 1 true for gzip */
    int havedict;               /* true if dictionary provided */
    int flags;                  /* gzip header method and flags (0 if zlib) */
    unsigned dmax;              /* zlib header max distance (INFLATE_STRICT) */
    unsigned long check;        /* protected copy of check value */
    unsigned long total;        /* protected copy of output count */
    gz_headerp head;            /* where to save gzip header information */
        /* sliding window */
    unsigned wbits;             /* log base 2 of requested window size */
    unsigned wsize;             /* window size or zero if not using window */
    unsigned whave;             /* valid bytes in the window */
    unsigned write;             /* window write index */
    unsigned char FAR *window;  /* allocated sliding window, if needed */
        /* bit accumulator */
    unsigned long hold;         /* input bit accumulator */
    unsigned bits;              /* number of bits in "in" */
        /* for string and stored block copying */
    unsigned length;            /* literal or length of data to copy */
    unsigned offset;            /* distance back to copy string from */
        /* for table and code decoding */
    unsigned extra;             /* extra bits needed */
        /* fixed and dynamic code tables */
    code const FAR *lencode;    /* starting table for length/literal codes */
    code const FAR *distcode;   /* starting table for distance codes */
    unsigned lenbits;           /* index bits for lencode */
    unsigned distbits;          /* index bits for distcode */
        /* dynamic table building */
    unsigned ncode;             /* number of code length code lengths */
    unsigned nlen;              /* number of length code lengths */
    unsigned ndist;             /* number of distance code lengths */
    unsigned have;              /* number of code lengths in lens[] */
    code FAR *next;             /* next available space in codes[] */
    unsigned short lens[320];   /* temporary storage for code lengths */
    unsigned short work[288];   /* work area for code table building */
    code codes[ENOUGH];         /* space for code tables */
};

#endif
