/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	header of EZ Comm Project common functionalities
 */

#include "ezcomm.h"

using namespace ezproject;

/*	socket abstraction	*/
bool ezcommSocket::set(std::string ip, int port)
{
	sin.sin_addr.s_addr = ip.size() ? inet_addr(ip.c_str()) : INADDR_ANY;
	sin.sin_port = htons(port);
	return true;	/* no checking so far */
}

std::string ezcommSocket::ip() const
{
	if (INADDR_ANY == sin.sin_addr.s_addr)
		return "*";

	struct in_addr ad;
	
	ad.s_addr = sin.sin_addr.s_addr;
	return inet_ntoa(ad);
}

int ezcommSocket::port() const
{
	return ntohs(sin.sin_port);
}


/*	communication abstraction */
//##ModelId=46A07D0E0128
void ezComm::setLocal(ezcommSocket *local)
{
	if (localSocket)
		delete localSocket;
	localSocket = local;
}

//##ModelId=46A07EED0251
void ezComm::setRemote(ezcommSocket *remote)
{
	if (remoteSocket)
		delete remoteSocket;
	remoteSocket = remote;
}

//##ModelId=46B04D9803DC
void ezComm::setSocket(socketIDs socket, ezcommSocket *local,
	ezcommSocket *remote)
{
	socketID = socket;
	setLocal(local);
	setRemote(remote);
	establish();
}

bool ezComm::setBuffSize(size_t size)
{
	static std::string sample;

	if (size <= sample.max_size())
	{
		if (!size)
			buffSize = sample.max_size();
		else
			buffSize = size;
		return true;
	}
	else
		return false;
}
