/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	header of EZ Comm Project common functionalities
 */

#ifndef EZCOMM_H
#define EZCOMM_H

#include <string>

#ifdef ULTIMATEPP
#include "winsock2.h"
#include <ezcommon/ezcommon.h>

typedef SOCKET socketIDs;
#else
#include <sys/socket.h>
#include <ezproject/ezcommon.h>

typedef int socketIDs;
#endif

namespace ezproject {

class ezcommSocket
{
public:
	ezcommSocket() { memset(&sin, 0, sizeof(sin)); sin.sin_family = AF_INET; };
//	ezcommSocket(const ezcommSocket &dup) { memcpy(&sin, dup.sock(), sizeof(sin)); };
	static int size() { return sizeof(struct sockaddr_in); };
	bool set(std::string ip, int port);
	std::string ip() const;
	int port() const;
	struct sockaddr *sock()
		{ return reinterpret_cast<struct sockaddr *>(&sin); };

private:
	struct sockaddr_in sin;
};


typedef void (*cbConnected)(socketIDs socket, ezcommSocket &remote,
	std::string content);
typedef void (*cbRecieved)(std::string content);

//##ModelId=46A05E3A0213
class ezComm
{
  public:
    ezComm(cbConnected connected, cbRecieved received)
    	: connectedCb(connected), receivedCb(received),
    		socketStatus(SOCKET_CLOSED) { buffSize = 256; };
    ~ezComm() { delete localSocket; delete remoteSocket; };

    //##ModelId=46A07D0E0128
    void setLocal(ezcommSocket *local);

    //##ModelId=46A07EED0251
    void setRemote(ezcommSocket *remote);

    //##ModelId=46B04D9803DC
    void setSocket(socketIDs socket, ezcommSocket *local, ezcommSocket *remote);

    bool setBuffSize(size_t size);

    //##ModelId=46A08411038A
    virtual void establish() = 0;

    //##ModelId=46A0843D0290
    virtual bool serve() = 0;

    //##ModelId=46A084620186
    virtual void disconnect() = 0;

    //##ModelId=46A084900290
    virtual void neglect() = 0;

    //##ModelId=46A0849D00DA
    virtual erttp transmit(std::string content) = 0;

  protected:
    size_t buffSize;
    socketIDs socketID;
    enum
    {
        SOCKET_CLOSED,
        SOCKET_OPENED,
        SOCKET_CONNECTED
    } socketStatus;
    //##ModelId=46A06F54036B
    cbConnected connectedCb;
    //##ModelId=46A0785602CE
    cbRecieved receivedCb;
    //##ModelId=46A078E400FA
    ezcommSocket *localSocket;
    //##ModelId=46A07C400261
    ezcommSocket *remoteSocket;

  private:
    ezComm &operator=(const ezComm &sth);	//we just don't need this
    ezComm(const ezComm &sth);	//we just don't need this
};

}	/*	namespace ezproject	*/

#endif	/*	EZCOMM_H	*/

