#include "aImageCtrl.h"

aImageCtrl::aImageCtrl()
{ 
	Transparent(); 
	NoWantFocus();
	AddFrame(status);
	AddFrame(scroll); 
	scroll.WhenScroll = THISBACK(Scroll);
	zoomF = 1.0;
}

aImageCtrl&	 aImageCtrl::SetImage(const Image& _img)
{ 
	img = _img;
	Fit();
	return *this; 
}

Image aImageCtrl::CursorImage(Point p, dword) {
	if(HasCapture())
		return Image::SizeAll;
	return Image::Arrow();
}

Point aImageCtrl::toImage(const Point& p)
{
	return Point( (int) ((double) p.x / zoomF), (int) ((double) p.y / zoomF));
}

Point aImageCtrl::toWin(const Point& p)
{
	return Point( (int) ((double) p.x * zoomF), (int) ((double) p.y * zoomF));
}

void aImageCtrl::Fit()
{
	double zoomx = (double) GetSize().cx / (double) img.GetSize().cx;
	double zoomy = (double) GetSize().cy / (double) img.GetSize().cy;
	zoomF =std::min(zoomx, zoomy);
	scroll.SetTotal(img.GetSize() * zoomF);
	Refresh();
}

void aImageCtrl::TruePixel()
{
	zoomF = 1;
	scroll.SetTotal(img.GetSize() * zoomF);
	Refresh();
}

void aImageCtrl::LocalMenu(Bar& bar)
{
	bar.Add("Fit to window", THISBACK(Fit)); 
	bar.Add("True Pixel Size", THISBACK(TruePixel));	
}



void aImageCtrl::LeftDown(Point p, dword keyflags)
{
	p_a = scroll + p;
	SetCapture();
	Refresh();
}

void aImageCtrl::RightDown(Point p, dword keyflags)
{
	MenuBar::Execute(THISBACK(LocalMenu));
}

void aImageCtrl::MouseMove(Point p, dword keyflags)
{
	if(HasCapture()) {
		scroll.Set(scroll - toImage(scroll + p - p_a));
	}
	// TODO: Needs fixing, this doesn't work when imgsize<winsize
	status = Format("Cursor Location : %d, %d . Zoom: %5.2f x", scroll.x / zoomF + p.x / zoomF, scroll.y / zoomF + p.y / zoomF,zoomF);
}

void aImageCtrl::MouseWheel(Point p, int zdelta, dword keyflags)
{
	
	Size sz = GetSize();
	Point pos = scroll, delta;

	// Setting the new zoom factor
	double zcumul = (double) zdelta / 2400.0;	
	zoomF = zoomF * (1.0 + zcumul);
	
	// Setting total size of scrollbar to new size
	scroll.SetTotal(toWin(img.GetSize()));

	// Calculating the new position of scrollbar
	pos.x = (int) ((double) pos.x *(1.0 + zcumul));
	pos.y = (int) ((double) pos.y *(1.0 + zcumul));
	delta.x = (int) ((double) p.x *(zcumul));
	delta.y = (int) ((double) p.y *(zcumul));
	pos += delta;
	
	// Setting new scrollbar position
	scroll.Set(pos);
	// TODO: Needs fixing, this doesn't work when imgsize<winsize
	status = Format("Cursor Location : %d, %d . Zoom: %5.2f x", scroll.x / zoomF + p.x / zoomF, scroll.y / zoomF + p.y / zoomF,zoomF);
	Refresh();
	
}


void aImageCtrl::Paint(Draw& w)
{
	if(img) {
		
		Size 	win_size = GetSize(), img_size = img.GetSize();
		
		Point 	pos = scroll;	pos = toImage(pos);		// Coordinates mapped to Image 
		Point 	sz = win_size;	sz = toImage(sz); 		// Coordinates mapped to Image
		int 	wx 	= 0, wy  = 0,	wWidth, wHeight;	// The portion of the window that drawing will take place.
		int 	px1 = 0, py1 = 0,	px2,	py2;		// The portion of the image that will be drawn.	
					
		// Choosing wether the image will fill the window or only a portion of it
			if (sz.x > img_size.cx) {
				px2   = img_size.cx;
				wWidth = (int) ((double) img_size.cx * zoomF);
				wx = (win_size.cx - wWidth) / 2;
			} 	
			else {
				px1	= pos.x;
				px2	= std::min(img_size.cx, pos.x + sz.x);
				wWidth = win_size.cx;
			}
			
			if (sz.y > img_size.cy) {
				py2   = img_size.cy;
				wHeight = (int) ((double) img_size.cy * zoomF);
				wy = (win_size.cy - wHeight) / 2;
			}
			else {
				py1	= pos.y;
				py2	= std::min(img_size.cy, pos.y + sz.y);
				wHeight = win_size.cy;
			}
			Rect iRect = Rect(px1, py1, px2, py2);			// The portion of the image that will be drawn.
		
		// If something changes find the new image portion to draw
			if (wxc!=wx || wyc!=wy || wWidthc!=wWidth || wHeightc!=wHeight || iRectc!=iRect)	
				imgc = Rescale(img, Size(wWidth, wHeight), iRect); 
			
		// Redrawing
			w.DrawImage(wx, wy, imgc);
		
		// Drawing image frame
			Vector<Point> poly;
			poly 	<< Point(wx - 2 ,wy - 2) << Point(wx + wWidth + 2, wy - 2) 
					<< Point(wx + wWidth + 2, wy + wHeight + 2) << Point(wx - 2,wy+wHeight+2) << Point(wx-2,wy-2);
			w.DrawPolyline(poly,2, Gray());
		
		// Updating drawimage attributes	
			wxc=wx; wyc=wy; wWidthc=wWidth; wHeightc=wHeight; iRectc=iRect;
		
	}
	
	
}
void aImageCtrl::Layout()
{
	
	scroll.SetPage(GetSize());
	scroll.SetTotal(img.GetSize() * zoomF);
}

void aImageCtrl::Scroll()
{
	SetFocus();
	Refresh();
}		
