#ifndef _DropTest_DropTest_h
#define _DropTest_DropTest_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <DropTest/DropTest.lay>
#include <CtrlCore/lay.h>

template <class T>
class MyFrameTop : public T {
public:
	virtual void FrameLayout(Rect& r) {
		LayoutFrameTop(r, this, this->cy ? this->cy : r.Width());
	}
	virtual void FrameAddSize(Size& sz) { sz.cy += (cy ? cy : sz.cx) * this->IsShown(); }

protected:
	int cy;

public:
	MyFrameTop& Height(int _cy)            	{ cy = _cy; this->RefreshParentLayout(); return *this; }
	int      GetHeight() const          	{ return cy; }
	MyFrameTop()                           	{ cy = 0; }
};

class DropTest : public WithDropTestLayout<TopWindow> {
public:
	typedef DropTest CLASSNAME;
	
	MyFrameTop<DropList> drop;
	
	DropTest();
};

#endif

