#include "dirs.h"

#ifdef PLATFORM_WIN32
String ExpandEnvironmentString(const String &s)
{
	if (s.GetLength() <= 2) return s;
	StringBuffer out;
	int ixl = 0, ixr = -1;
	bool env = false;
	for (;;) {
		ixr = s.Find('%', ixr+1);
		if (ixr >= 0) {
			if (env) {
				String t = FromSystemCharset(getenv(s.Mid(ixl, ixr-ixl)));
				out << (t.GetLength() ? t : s.Mid(ixl-1, ixr-ixl+2));
			}
			else
				out << s.Mid(ixl, ixr-ixl);
			env = !env;		
			ixl = ixr+1;
		}
		else 
			break;
	}
	out << s.Right(s.GetLength() - ixl);
	return out;
};

#ifndef PLATFORM_WINCE
String GetShellFolder(const char *folder)
{
	String reg_key = GetWinRegString(folder, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", HKEY_CURRENT_USER);
	if (reg_key.IsVoid()) {
		reg_key = GetWinRegString(folder, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", HKEY_LOCAL_MACHINE);
		if (reg_key.IsVoid()) {
			reg_key = GetWinRegString(folder, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", HKEY_CURRENT_USER);
			if (reg_key.IsVoid())
				reg_key = GetWinRegString(folder, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", HKEY_LOCAL_MACHINE);
		}
	}				
	return ExpandEnvironmentString(reg_key);	
};

String GetDocumentDirectory()				
{
	return GetShellFolder("Personal");
}

String GetDesktopDirectory()				
{
	return GetShellFolder("Desktop");
}

String GetPicturesDirectory()				
{
	return GetShellFolder("My Pictures");
}

String GetVideosDirectory()					
{
	return GetShellFolder("My Videos");
}

String GetRecentDirectory()					
{
	return GetShellFolder("Recent");
}
#endif

#endif

#ifdef PLATFORM_POSIX
String GetDocumentDirectory()				
{
	return GetHomeDirectory();
}

String GetDesktopDirectory()				
{
	return GetHomeDirectory();
}

String GetPicturesDirectory()				
{
	return GetHomeDirectory();
}

String GetVideosDirectory()					
{
	return GetHomeDirectory();
}

String GetRecentDirectory()					
{
	return GetHomeDirectory();
}
#endif

String GetDocumentDirFile(const char *fp)	
{
	return AppendFileName(GetDocumentDirectory(), fp);
}

String GetDesktopDirFile(const char *fp)	
{
	return AppendFileName(GetDesktopDirectory(), fp);
}

String GetPicturesDirFile(const char *fp)	
{
	return AppendFileName(GetPicturesDirectory(), fp);
}

String GetVideosDirFile(const char *fp)		
{
	return AppendFileName(GetVideosDirectory(), fp);
}

String GetRecentDirFile(const char *fp)		
{
	return AppendFileName(GetRecentDirectory(), fp);
}

