#ifndef _FrameTest_FrameTest_h
#define _FrameTest_FrameTest_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <FrameTest/FrameTest.lay>
#include <CtrlCore/lay.h>

#include "ExpandFrame.h"

class FrameTest : public WithFrameTestLayout<TopWindow> {
public:
	ExpandFrame frames[3];
	WithSearchLayout<ParentCtrl> search;
	
	TreeCtrl tree;
	ArrayCtrl array;
	
	typedef FrameTest CLASSNAME;
	FrameTest();
	
	void FillTree(TreeCtrl &tree) {
		Vector<int> parent, parent2;
		parent.Add(0);
		tree.SetRoot(Image(), "The Tree");
		for(int i = 1; i < 10000; i++) {
			parent.Add(tree.Add(parent[rand() % parent.GetCount()], Image(),
			            FormatIntRoman(i, true)));
			if((rand() & 3) == 0)
				tree.Open(parent.Top());
		}
		tree.Open(0);					
	}
	
	void FillArray(ArrayCtrl &array) {
		array.AddColumn("Number");
		array.AddColumn("Roman numbers");
		array.MultiSelect();
		for(int i = 0; i < 200; i++)
			array.Add(i, FormatIntRoman(i, true));		
	}	
};

#endif

