#ifndef _CryptOpenSsl_CryptOpenSsl_h_
#define _CryptOpenSsl_CryptOpenSsl_h_

// ---------------------------------------------------------------------------------------------

#include <Core/Core.h>
#include <UnitTest/UnitTest.h>

 #define OPENSSL_THREAD_DEFINES
 #include <openssl/opensslconf.h>
 #if !defined(OPENSSL_THREADS)
 @@@
 #endif
 
#include <openssl/rsa.h>
#include <openssl/engine.h>
#include <openssl/pem.h>

using namespace Upp;

// ---------------------------------------------------------------------------------------------

String ToString(BIGNUM *b);
BIGNUM * ToBigNum(String& str);
String ToString(BIO *bp);
BIO * ToBIO(String &str);

// ---------------------------------------------------------------------------------------------

struct Rsa : public Moveable<Rsa> {
	Rsa() { rsa = NULL; }
	~Rsa() { if(rsa) RSA_free(rsa); }
	
	void GenerateKeyPair(int bits = 1024, int exponent = 17);

	String PrivateKeyToPem();
	String PublicKeyToPem();
	void PrivateKeyFromPem(const String &pem);
	void PrivateKeyFromPem(uint8 *d, int l);
	void PublicKeyFromPem(const String &pem);
	void PublicKeyFromPem(uint8 *d, int l);
		
	String SignSHA(const String &msg);
	String Decrypt(const String &msg, int padding = RSA_PKCS1_OAEP_PADDING);
	
	bool VerifySHA(const String &msg, const String &sig);
	String Encrypt(const String &msg, int padding = RSA_PKCS1_OAEP_PADDING);
		
	int MaxMsgCount(int padding = RSA_PKCS1_OAEP_PADDING);
	
	void Serialize(Stream &s);
	
protected:
	RSA *rsa;
};

// ---------------------------------------------------------------------------------------------

#endif
