/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	source code of EZ Comm Project Ultimate++ functionalities
 */

#include "main.h"

#define IMAGEFILE <ezcomm/ezcomm.iml>
#include <Draw/iml_source.h>

bool ezcommwin::HotKey(dword key)
{
	switch (key)
	{
		case K_ENTER:
		case K_CTRL_ENTER:
			Butt_out();
			return true;
	}
	return false;
}

void ezcommwin::WClose()
{
	/* validate controls */
	port_out.Clear();
	port_lcl.Clear();

	/* resource release */
	WSACleanup();
	delete ezcomm;

	/* go on termination */
	Close();
}

void ezcommwin::Ip_out()
{
	lowlight_ctrl(&ip_out);
	changes |= CHANGES_RMT;
}

void ezcommwin::Port_out()
{
	lowlight_ctrl(&port_out);
	changes |= CHANGES_RMT;
}

void ezcommwin::Port_lcl()
{
	lowlight_ctrl(&port_lcl);
	changes |= CHANGES_LCL;
}

void ezcommwin::Ip_lcl()
{
	changes |= CHANGES_LCL;
}

void ezcommwin::Hist_text_out()
{
	text_out.Set(hist_text_out.GetValue().ToString());
	text_out.SetFocus();
}

using namespace ezproject;

ezcommwin::ezcommwin()
{
	/* interface */
	CtrlLayout(*this, "EZ Comm");
	Icon(IMAGECLASS::Get("ico"), IMAGECLASS::Get("ico"));
	arr_r.SetImage(IMAGECLASS::Get("arrow_r"));
	arr_l.SetImage(IMAGECLASS::Get("arrow_l"));
	arr_o.SetImage(IMAGECLASS::Get("arrow_r"));
	arr_i.SetImage(IMAGECLASS::Get("arrow_l"));
	port_out.Min(1);
	port_out.Max(65535);
	port_lcl.Min(1);
	port_lcl.Max(65535);
	comm_type.Set(0, COMM_TYPE_UDP, "UDP");
	comm_type.Set(1, COMM_TYPE_TCP, "TCP");
	comm_type.DisableCase(1);
	comm_type.EnableCase(0);
	comm_type.Tip("select communication method");
	msg.Add("Have a nice day.");
	msg.Add("Bonjour.");
	msg.Add("Salut");
	msg.Add("hallo");
	msg.Add("ciao");
	msg.Add("hola");
	msg.Add("written by Allen");
	msg.Add("a sub-project of EZ Project");
	msg.Add("http://ezproject.sourceforge.net/");
	msg.Add("Windows or Linux, Text or Graphical.");
	msg.Add("Anti-Discrimination");
	msg.Add("cannot be used by Japanese who hold hostility against Chinese");
	msg.Add("cannot be used by those who have race discrimination");
	msg.Add("cannot be used by those who have gender discrimination");
	msg.Add("cannot be used by those who have sexual orientation discrimination");
	info.NoSb();
	disp(ezoi::OILVL_NA, "under GPL with\n a couple of exception rules");
	changes = 0;

	/* callbacks */
	ip_out <<= THISBACK(Ip_out);
	port_out <<= THISBACK(Port_out);
	port_lcl <<= THISBACK(Port_lcl);
	ip_lcl <<= THISBACK(Ip_lcl);
	hist_text_out.WhenAction = THISBACK(Hist_text_out);
	butt_clr <<= THISBACK(Butt_clr);
	butt_out <<= THISBACK(Butt_out);
	butt_in <<= THISBACK(Butt_in);
	WhenClose = THISBACK(WClose);
	comm_type <<= THISBACK(Comm_type);

	/* styles */
	lowlight_style = EditField::StyleDefault();
	highlighted_ctrl = NULL;
	
	/* members */
	ezcomm = NULL;
        securities_thread.nLength = sizeof(SECURITY_ATTRIBUTES);
        securities_thread.lpSecurityDescriptor = NULL;
        securities_thread.bInheritHandle = TRUE;

	WSADATA wsaData;

	WSAStartup(MAKEWORD(2,2), &wsaData);
}

void ezcommwin::Comm_type()
{
	disp(ezoi::OILVL_WARN, "TCP not supported yet...");
	changes |= CHANGES_TYPE;
}

void ezcommwin::highlight_ctrl(EditField *ctrl)
{
	lowlight_ctrl(NULL);
	if (ctrl)
	{
		EditField::Style highlight_style = lowlight_style;
		highlight_style.paper = Red();
		ctrl->SetStyle(highlight_style);
		ctrl->SetFocus();
	}
	highlighted_ctrl = ctrl;
}

/*
parameter:	ctrl: NULL: reset highlighted one; non-NULL: reset the control
	if it is highlighted
*/
void ezcommwin::lowlight_ctrl(EditField *ctrl)
{
	if (highlighted_ctrl)
	{
		if (!ctrl || (ctrl == highlighted_ctrl))
		{
			highlighted_ctrl->SetStyle(lowlight_style);
			highlighted_ctrl = NULL;
			if (ctrl)
				Butt_clr();
		}
	}
}

void ezcommwin::disp(ezoi::eoilvl lvl, const char *cnt)
{
	const char * decorations = "";
	std::string lbl("[7@4A=");

	switch (lvl)
	{
		case ezoi::OILVL_FATAL:
			decorations = "*_";
			break;
		case ezoi::OILVL_WARN:
			decorations = "*d";
			break;
		case ezoi::OILVL_INFO:
			decorations = "";
			break;
		case ezoi::OILVL_NA:
			decorations = "/";
			break;
	}
	lbl.append(decorations);
	lbl.append(" ");
	lbl.append(cnt);
	lbl.append("]");
	info.SetData(lbl.c_str());
}

void ezcommwin::func_rcv(void *remoteI)
{
	ezcommSocket *remote = static_cast<ezcommSocket *>(remoteI);
	try
	{
		switch (ezcomm->establish(remote))
		{
			case RTTP_RGHT:
				disp(ezoi::OILVL_WARN, "OK");
				break;
			case RTTP_CRER:
				disp(ezoi::OILVL_WARN, "NOT OK");
				break;
		}
	}
	catch (std::string err)
	{
		disp(ezoi::OILVL_FATAL, err.c_str());
	}
	catch (int code)
	{
		switch (code)
		{
			case WSANOTINITIALISED:
				disp(ezoi::OILVL_FATAL, "A successful WSAStartup call must occur before using this function.");
				break;
			case WSAENETDOWN:
				disp(ezoi::OILVL_FATAL, "The network subsystem has failed.");
				break;
			case WSAEINPROGRESS:
				disp(ezoi::OILVL_FATAL, "A blocking Windows Sockets 1.1 call is in progress, or the service provider is still processing a callback function.");
				break;
			case WSA_NOT_ENOUGH_MEMORY:
				disp(ezoi::OILVL_FATAL, "Not enough free memory was available to complete the operation.");
				break;
			case WSA_INVALID_HANDLE:
				disp(ezoi::OILVL_FATAL, "One or more of the values in the lphEvents array is not a valid event object handle.");
				break;
			case WSA_INVALID_PARAMETER:
				disp(ezoi::OILVL_FATAL, "The cEvents parameter does not contain a valid handle count.");
				break;
			case WSAEACCES:
				disp(ezoi::OILVL_FATAL, "The requested address is a broadcast address, but the appropriate flag was not set. Call setsockopt with the SO_BROADCAST parameter to allow the use of the broadcast address.");
				break;
			case WSAEINVAL:
				disp(ezoi::OILVL_FATAL, "An unknown flag was specified, or MSG_OOB was specified for a socket with SO_OOBINLINE enabled.");
				break;
			case WSAEINTR:
				disp(ezoi::OILVL_FATAL, "A blocking Windows Sockets 1.1 call was canceled through WSACancelBlockingCall.");
				break;
			case WSAEFAULT:
				disp(ezoi::OILVL_FATAL, "The buf or to parameters are not part of the user address space, or the tolen parameter is too small.");
				break;
			case WSAENETRESET:
				disp(ezoi::OILVL_FATAL, "The connection has been broken due to keep-alive activity detecting a failure while the operation was in progress.");
				break;
			case WSAENOBUFS:
				disp(ezoi::OILVL_FATAL, "No buffer space is available.");
				break;
			case WSAENOTCONN:
				disp(ezoi::OILVL_FATAL, "The socket is not connected (connection-oriented sockets only).");
				break;
			case WSAENOTSOCK:
				disp(ezoi::OILVL_FATAL, "The descriptor is not a socket.");
				break;
			case WSAEOPNOTSUPP:
				disp(ezoi::OILVL_FATAL, "MSG_OOB was specified, but the socket is not stream-style such as type SOCK_STREAM, OOB data is not supported in the communication domain associated with this socket, or the socket is unidirectional and supports only receive operations.");
				break;
			case WSAESHUTDOWN:
				disp(ezoi::OILVL_FATAL, "The socket has been shut down; it is not possible to sendto on a socket after shutdown has been invoked with how set to SD_SEND or SD_BOTH.");
				break;
			case WSAEWOULDBLOCK:
				disp(ezoi::OILVL_FATAL, "The socket is marked as nonblocking and the requested operation would block.");
				break;
			case WSAEMSGSIZE:
				disp(ezoi::OILVL_FATAL, "The socket is message oriented, and the message is larger than the maximum supported by the underlying transport.");
				break;
			case WSAEHOSTUNREACH:
				disp(ezoi::OILVL_FATAL, "The remote host cannot be reached from this host at this time.");
				break;
			case WSAECONNABORTED:
				disp(ezoi::OILVL_FATAL, "The virtual circuit was terminated due to a time-out or other failure. The application should close the socket as it is no longer usable.");
				break;
			case WSAECONNRESET:
				disp(ezoi::OILVL_FATAL, "The virtual circuit was reset by the remote side executing a hard or abortive close. For UPD sockets, the remote host was unable to deliver a previously sent UDP datagram and responded with a Port Unreachable ICMP packet. The application should close the socket as it is no longer usable.");
				break;
			case WSAEADDRNOTAVAIL:
				disp(ezoi::OILVL_FATAL, "The remote address is not a valid address, for example, ADDR_ANY.");
				break;
			case WSAEAFNOSUPPORT:
				disp(ezoi::OILVL_FATAL, "Addresses in the specified family cannot be used with this socket.");
				break;
			case WSAEDESTADDRREQ:
				disp(ezoi::OILVL_FATAL, "A destination address is required.");
				break;
			case WSAENETUNREACH:
				disp(ezoi::OILVL_FATAL, "The network cannot be reached from this host at this time.");
				break;
			case WSAETIMEDOUT:
				disp(ezoi::OILVL_FATAL, "The connection has been dropped, because of a network failure or because the system on the other end went down without notice.");
				break;
		}
	}
	return;
	/*WaitForSingleObject(handle_rcv, DWORD);
	WaitForMultipleObjects(DWORD, const HANDLE *, BOOL, DWORD);*/
	while(true)
	{
		/*ReadFile(handle_rcv, PVOID, DWORD, PDWORD, LPOVERLAPPED);
		ezcomm->serve();*/
		/*switch(1)
		{
			case COMM_THREAD_SEND:
				try
				{
					ezcomm->establish();
					switch (ezcomm->transmit(text_out.Get()))
					{
						case RTTP_RGHT:
							disp(ezoi::OILVL_INFO, "data sent.");
							break;
						case RTTP_MNER:
							disp(ezoi::OILVL_WARN, "data partially sent.");
							break;
						default:
							disp(ezoi::OILVL_FATAL, "this is a bug!");
					}
				}
				catch (std::string msg)
				{
					disp(ezoi::OILVL_FATAL, msg.c_str());
				}
				break;
			case COMM_THREAD_LOCAL:
				break;
			case COMM_THREAD_REMOTE:
				break;
			case COMM_THREAD_KILL:
				break;
		}*/
	}

	ezcomm->disconnect();
}

void cb_exec(void * holder, enum eaction action, ezComm *commPair,
	std::pair<ezcommSocket *, ezcommSocket *> sockPair, std::string buf)
{
	ezcommwin *ez = static_cast<ezcommwin *>(holder);
	ez->cb_rcv(action, commPair, sockPair, buf);
}

void ezcommwin::cb_rcv(enum eaction action, ezComm *commPair,
	std::pair<ezcommSocket *, ezcommSocket *>, std::string buf)
{
	switch (action)
	{
		case ACTION_SERVE:
			break;
		case ACTION_ESTABLISH:
			if (0 == buf.length())
			{
				ezcomm->transmit(text_out.Get());
			}
			else
				disp(ezoi::OILVL_FATAL, buf.c_str());
			break;
		case ACTION_RECEIVE:
			text_in.Set(buf);
			disp(ezoi::OILVL_INFO, "sth. received");
			break;
		case ACTION_TRANSMIT:
			if (0 != buf.length())
				disp(ezoi::OILVL_FATAL, buf.c_str());
			break;
		case ACTION_DISCONNECT:
			break;
/*		case ACTION_NEGLECT:
			break;*/
		case ACTION_MAX:
			break;
	}
}

/*#include <stdio.h>
#include "winsock2.h"*/

void ezcommwin::Butt_out()
{
	if ((0 == ip_out.GetLength()) || (0 == port_out.GetLength()))
	{
		disp(ezoi::OILVL_FATAL, "Input destination's IP & port!");
		if (0 == ip_out.GetLength())
		{
			highlight_ctrl(&ip_out);
		}
		else
			highlight_ctrl(&port_out);
	}
	else
	{
		String ip;
		int port;

		if (changes & CHANGES_TYPE)
		{
			if (ezcomm)
			{
				ASSERT(thread_rcv.GetCount() > 0);
				/*if (!WriteFile(handle_snd, PCVOID, DWORD, PDWORD, LPOVERLAPPED))*/
				{	/* kill thread */
				}
				delete ezcomm;
				ezcomm = NULL;
			}
			changes &= ~CHANGES_TYPE;
		}
		switch (comm_type)
		{
			case COMM_TYPE_UDP:
				if (!ezcomm)
				{
					/*if (thread_rcv.GetCount() < 1)
					{
						CreatePipe(&handle_rcv, &handle_snd, &securities_thread, 0);
						thread_rcv.Run(callback1(this, &ezcommwin::func_rcv, static_cast<void *>(NULL)));
					}*/
				}
				if (changes & CHANGES_LCL)
				{
					ezcommSocket *local = new(ezcommSocket);

					ip = ip_lcl.GetData();
					if (port_lcl.GetLength())
						port = port_lcl.GetData();
					else
						port = 0;
					local->set(ip, port);
					ezcomm = new ezUdp(cb_exec, this, local);
					/*changes &= ~CHANGES_LCL;*/
				}
				if (changes & CHANGES_RMT)
				{
					ezcommSocket *remote = new(ezcommSocket);

					ip = ip_out.GetData();
					port = port_out.GetData();
					remote->set(ip, port);
					
					thread_rcv.Run(callback1(this, &ezcommwin::func_rcv, static_cast<void *>(remote)));
					/*changes &= ~CHANGES_RMT;*/
				}
				if (changes)
				{
#if 0
					ezcomm->disconnect();
					ezcomm->establish();
#endif
					changes = 0;
				}

				break;
			case COMM_TYPE_TCP:
				break;
		}
		//SetEvent
		ip_out.AddHistory(HIST_DROP_NUM);
		port_out.AddHistory(HIST_DROP_NUM);
		hist_text_out.Add(text_out.Get());
		text_out.SetCursor(0);
	}
}

void ezcommwin::Butt_in()
{
		String ip;
		int port;
				if (!ezcomm)
				{
					/*if (thread_rcv.GetCount() < 1)
					{
						CreatePipe(&handle_rcv, &handle_snd, &securities_thread, 0);
						thread_rcv.Run(callback1(this, &ezcommwin::func_rcv, static_cast<void *>(NULL)));
					}*/
					/*ezcomm = new ezUdp(NULL, NULL);*/
				}
				if (changes & CHANGES_LCL)
				{
					ezcommSocket *local = new(ezcommSocket);

					ip = ip_lcl.GetData();
					if (port_lcl.GetLength())
						port = port_lcl.GetData();
					else
						port = 0;
					local->set(ip, port);
					/*ezcomm->setLocal(local);
					/*changes &= ~CHANGES_LCL;*/
				}
				if (changes & CHANGES_RMT)
				{
					ezcommSocket *remote = new(ezcommSocket);

					ip = ip_out.GetData();
					port = port_out.GetData();
					remote->set(ip, port);
					/*ezcomm->setRemote(remote);
					/*changes &= ~CHANGES_RMT;*/
				}
/*	if (ezcomm->listening())
	{
		butt_in.SetLabel("listen");
	}
	else*/
	{
		if (0 == port_lcl.GetLength())
		{
			disp(ezoi::OILVL_FATAL, "Input local port!");
			highlight_ctrl(&port_lcl);
		}
		else
		{
			thread_rcv.Run(callback1(this, &ezcommwin::func_rcv, static_cast<void *>(NULL)));
			butt_in.SetLabel("stop listening");
			disp(ezoi::OILVL_INFO, "listening...");
		}
	}
}

void ezcommwin::Butt_clr()
{
	disp(ezoi::OILVL_NA, msg.At(rand() % msg.GetCount()));
}

GUI_APP_MAIN
{
	ezcommwin ezcw;

	ezcw.Run();
}

