/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	source code of EZ Comm Project UDP functionalities
 */

#include <sstream>
#include "ezudp.h"
/*#include <stdio.h>
#include <stdlib.h>
#ifdef OLD_IOSTREAM
#include <iostream.h>
#else
#include <iostream>
#endif
#include <signal.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <errno.h>
#include <pthread.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>*/

using namespace ezproject;

void ezUdp::relate(void)
{
	if (socketStatus != SOCKET_CLOSED)
		return;	/* already bound */

	socketID = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

	socketStatus = SOCKET_OPENED;
	if (!localSocket)
	{
	/*	localSocket = new ezcommSocket;
		int port;

		do
		{
			localSocket->set("", port);
		} while (bind(socketID, localSocket->sock(), localSocket->size()) < 0);
		if (0)
	*/		throw std::string("no available socket!");
	}
	else if (bind(socketID, localSocket->sock(), localSocket->size()) < 0)
	{
		std::stringstream msg;

		msg << "failed to bind to " << localSocket->ip() << ":"
			<< localSocket->port();
		throw msg.str();
	}
}

erttp ezUdp::establish(ezcommSocket* remote)
{
	relate();
	remoteSocket = remote;
/*	if (connect(socketID, remoteSocket->sock(), remoteSocket->size()) < 0)
		throw std::string("failed to connect!");*/
	if (socketStatus != SOCKET_LISTENING)
		socketStatus = SOCKET_CONNECTED;


				if (sendto(socketID, "testing", 7, 0,
					remoteSocket->sock(), remoteSocket->size()) > 0)
					return RTTP_RGHT;
				else
					throw WSAGetLastError();



	/* events */
	localEventDisconnect = WSACreateEvent();
	localEventTransmit = WSACreateEvent();
	localEventRead = WSACreateEvent();
	WSAEventSelect(socketID, localEventRead, FD_READ);

	const unsigned char offset = 1;
	const unsigned char quantity = 3;
	WSAEVENT evtArray[quantity];
	memset(evtArray, 0, sizeof(evtArray));
	evtArray[ACTION_RECEIVE - offset] = localEventRead;
	evtArray[ACTION_TRANSMIT - offset] = localEventTransmit;
	evtArray[ACTION_DISCONNECT - offset] = localEventDisconnect;

	DWORD evtIndex;
	ezcommSocket rcvSocket;
	char *buf = static_cast<char *>(malloc(buffSize));
	int bufLen;
	int socketLen = rcvSocket.size();
	std::pair<ezcommSocket*, ezcommSocket*> sockPair(localSocket, remoteSocket);

	callbacks(cbHolder, ACTION_ESTABLISH, NULL, sockPair, "");
	while (true)
	{
		evtIndex = WSAWaitForMultipleEvents(quantity, evtArray, FALSE, WSA_INFINITE, FALSE);
		if (WSA_WAIT_FAILED == evtIndex)
		{
			throw (WSAGetLastError());
		}
		evtIndex -= WSA_WAIT_EVENT_0;
		WSAResetEvent(evtArray[evtIndex]);
		switch (evtIndex)
		{
			case ACTION_RECEIVE - offset:
				bufLen = recvfrom(socketID, buf, buffSize - 1, 0, rcvSocket.sock(), &socketLen);
				buf[bufLen] = '\0';
				sockPair.second = &rcvSocket;
				callbacks(cbHolder, ACTION_RECEIVE, NULL, sockPair, buf);
				break;
			case ACTION_TRANSMIT - offset:
				bufLen = sendto(socketID, localEventString.c_str(), localEventString.length(), 0,
					remoteSocket->sock(), remoteSocket->size());
				sockPair.second = remoteSocket;
				if (SOCKET_ERROR == bufLen)
				{
					throw (WSAGetLastError());
				}
				callbacks(cbHolder, ACTION_TRANSMIT, NULL, sockPair, "");
				break;
			case ACTION_DISCONNECT - offset:
				break;
		}
	}

	return RTTP_RGHT;
}

erttp ezUdp::serve(void)
{
	char *buf;
	struct sockaddr rmtaddr;
	ezcommSocket rmtSock;
	int rmtaddr_len = rmtSock.size();

	socketID = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	buf = (char *)malloc(buffSize);
	relate();
	socketStatus = SOCKET_LISTENING;

	/* events */
	localEventDisconnect = WSACreateEvent();
	WSAEventSelect(socketID, localEventAccept, FD_READ);
#if 0
	while (true)
	{
		recvfrom(socketID, buf, buffSize, 0, rmtSock.sock(), &rmtaddr_len);
		connectedCb(socketID, rmtSock, buf);
	}
#endif
	return RTTP_RGHT;
}

#if 0
void ezUdp::disconnect()
{
	if (socketStatus != SOCKET_CLOSED)
	{
		closesocket(socketID);
		socketStatus = SOCKET_CLOSED;
	}
}

erttp ezUdp::transmit(std::string content)
{
	if (!socketID)
		throw std::string("no socket yet");

	int bytesSent;

	if ((bytesSent = send(socketID, content.c_str(), content.length() + 1, 0))
	    <= 0)
		throw std::string("failed to send!");
	if (content.length() + 1/*\0*/ != bytesSent)
		return RTTP_MNER;
	return RTTP_RGHT;
}
#endif
