#include "SocketServer.h"

void ProcessConnection(SocketServer *gui)
{
	Vector<SOCKET> vsock;
	String buffer;

	vsock.Add(gui->sock.GetSocket());
	
	gui->sock.Write("CONNECTED\n");
	
	while((!gui->terminated)&&(gui->sock.IsOpen()))
	{
		if(gui->sock.Wait(vsock,vsock,1000))
		{
			buffer = gui->sock.ReadUntil('\n');
			
			switch (buffer[0])
			{
				case 'F'	: //PostCallback(callback(gui, &SocketServer::FetchData));
							  gui->FetchData();
							  break;

				case 'U'	: //PostCallback(callback(gui, &SocketServer::UpdateData));
							  gui->UpdateData();
							  break;

				case 'R'	: //PostCallback(callback(gui, &SocketServer::ReportData));
							  gui->ReportData();
							  break;

				case 'S'	: //PostCallback(callback(gui, &SocketServer::ScheduleData));
							  gui->ScheduleData();
							  break;

				case 'D'	: //Exclamation("Socket closed by client");
							  return;
							  
				default		: gui->sock.Write("ERROR\n");
							  break;
			}
		}
		Sleep(1);
	}
}

void WaitForConnection(SocketServer *gui)
{
	if (!gui->sock.IsOpen()) 
	{
		gui->OpenSocket();
	}
	while((!gui->terminated)&&(gui->sock.IsOpen()))
	{
		if(gui->sock.Accept(gui->sock))
		{
			ProcessConnection(gui);
			gui->CloseSocket();
			gui->OpenSocket();
		}
		Sleep(1);
	}
	AtomicDec(gui->threads);
}

SocketServer::SocketServer()
{
	port = 4662;
	terminated = 0;
	threads = 0;
	CtrlLayout(*this, "SocketServer Server");
	ssw.SetLabel(0, Format("STOP %d",port));
	ssw.SetLabel(1, Format("START %d",port));
	ssw=0;

	ssw.WhenAction = THISBACK(SSwitch);

	Sizeable().Zoomable();
}

SocketServer::~SocketServer()
{
	CloseSocket();
	terminated = 1;
	while(threads)
		Sleep(10);
}

void SocketServer::SSwitch()
{
	if (ssw==0) {
		CloseSocket();
	}
	else if (ssw==1) {
		AtomicInc(threads);
		Thread().Run(callback1(WaitForConnection, this));
	}
	else	
		PromptOK("Warning: check your switch inits!");
}

void SocketServer::OpenSocket()
{
	ServerSocket(sock, port, true, 5, false);
}

void SocketServer::CloseSocket()
{
	sock.Close();
}

void SocketServer::FetchData() 
{
	char *buffer;
	int size;
	buffer = "FETCHED DATA\n";
	size = strlen(buffer);
	
	sock.WriteRaw((void*)buffer, size);
}

void SocketServer::UpdateData() 
{
	String buffer;
	Vector<SOCKET> readwrite;
	readwrite.Add(sock.GetSocket());
	
	sock.WriteRaw("SEND\n",5);
	
	for(;;)
	{
		if(sock.Wait(readwrite, readwrite, 1000))
		{
			buffer = sock.ReadUntil('\n',1000);
			DataST.SetText(buffer);
			sock.Write("DONE\n");
			break;
		}
		Sleep(1);
	}
}

void SocketServer::ReportData() 
{
	char *buffer;
	int size;
	buffer = "REPORTED DATA\n";
	size = strlen(buffer);
	
	sock.WriteRaw((void*)buffer, size);
}

void SocketServer::ScheduleData() 
{
	char *buffer;
	int size;
	buffer = "SCHEDULED DATA\n";
	size = strlen(buffer);
	sock.WriteRaw((void*)buffer, size);
}
