#include "SocketClient.h"

SocketClient::SocketClient()
{
	CtrlLayout(*this, "Socket Client");
	port = 4662;
	Server = "localhost";
	Connected = false;
	
	ConnectBTN.WhenPush = THISBACK(Connect);
	ReadBTN.WhenPush = THISBACK(Read);
	ReportBTN.WhenPush = THISBACK(Report);
	ScheduleBTN.WhenPush = THISBACK(Schedule);
	UpdateBT.WhenPush = THISBACK(Update);
}

bool SocketClient::OpenSocket()
{
	if(!ClientSocket(sock, Server, port, true, NULL, 5, false))
	{
		PromptOK("Socket Not Connected");
		return false;
	}
	return true;
}
// bool ClientSocket(Socket& socket, const char *host, int port, 
//					bool nodelay = true, dword *my_addr = NULL, 
//					int timeout = DEFAULT_CONNECT_TIMEOUT, bool is_blocking = true);

void SocketClient::CloseSocket()
{
	sock.Write("D\n");
	sock.Close();
}

void SocketClient::Connect()
{
	if(!OpenSocket())
		return;

	String Result = sock.ReadUntil('\n', 1000);
	
	Connected = (Result == "CONNECTED" ? true : false);
}

void SocketClient::Read()
{
	Vector<SOCKET> readwrite;
	if(!Connected)
	{
		Exclamation("Not Connected");
		return;
	}
	
	readwrite.Add(sock.GetSocket());
	
	sock.Write("F\n");
	for(;;)
	{
		if(sock.Wait(readwrite, readwrite, 1000))
		{
			String Result = sock.ReadUntil('\n');
			InputST.SetText(Result);
			if(Result.IsEmpty())
			{
				PromptOK("No Result");
			}
			break;
		}
		Sleep(1);
	}
}

void SocketClient::Report()
{
	Vector<SOCKET> readwrite;
	if(!Connected)
	{
		Exclamation("Not Connected");
		return;
	}
	
	readwrite.Add(sock.GetSocket());
	
	sock.Write("R\n");
	for(;;)
	{
		if(sock.Wait(readwrite, readwrite, 1000))
		{
			String Result = sock.ReadUntil('\n');
			InputST.SetText(Result);
			if(Result.IsEmpty())
			{
				PromptOK("No Result");
			}
			break;
		}
		Sleep(1);
	}
}

void SocketClient::Schedule()
{
	Vector<SOCKET> readwrite;
	if(!Connected)
	{
		Exclamation("Not Connected");
		return;
	}
	
	readwrite.Add(sock.GetSocket());
	
	sock.Write("S\n");
	for(;;)
	{
		if(sock.Wait(readwrite, readwrite, 1000))
		{
			String Result = sock.ReadUntil('\n');
			InputST.SetText(Result);
			if(Result.IsEmpty())
			{
				PromptOK("No Result");
			}
			break;
		}
		Sleep(1);
	}
}

void SocketClient::Update()
{
	Vector<SOCKET> readwrite;
	if(!Connected)
	{
		Exclamation("Not Connected");
		return;
	}
	
	readwrite.Add(sock.GetSocket());
	
	sock.Write("U\n");
	for(;;)
	{
		if(sock.Wait(readwrite, readwrite, 1000))
		{
			String Result = sock.ReadUntil('\n');
			sock.Write(Format("%s\n",~UpdateES));
//			sock.Wait(readwrite, readwrite, 1000);
			Result = sock.ReadUntil('\n');
			break;
		}
		Sleep(1);
	}
}
