#include <ide/Common/Common.h>

#include "QuickTabs.h"

static String ParseGroup(const String &s)
{
	if(!s.IsEmpty())
	{
		if(s[0] == '/' || s[0] == '\\')
			return s.Mid(1);
		else if(s[1] == ':')
			return s.Mid(3);
	}
	return Null;
}

QuickTabs::QuickTabs()
{
	file_icons = false;
}

void QuickTabs::ContextMenu(Bar& bar)
{
	TabBar::ContextMenu(bar);
	bar.Add("Close non-project tabs", WhenCloseRest);	
}

void QuickTabs::GroupMenu(Bar &bar, int n)
{
	bar.Add("Set active", THISBACK1(DoGrouping, n));
	bar.Add("Close", THISBACK1(DoCloseGroup, n));
}

void QuickTabs::DrawTabData(Draw& w, Point p, const Size &sz, const Value& q, const Font &font, Color ink, dword style)
{
//	TabBar::DrawTabData(w, p, sz, q, font, ink, style);
//	return;
	ASSERT(q.GetType() == STRING_V);
	String s = q.ToString();
	
	TabCenterText(p, sz, font);
	if(file_icons)
	{
		Image icon = IdeFileImage(s);
		int al = GetAlign();
		Point ip = p;
		Size isz = icon.GetSize();
		if (al == RIGHT)
			ip.x -= font.GetHeight();
		else if (al == LEFT)
			ip.y -= isz.cy;
		if (IsVert()) {
			w.DrawImage(ip.x-1, ip.y, icon);
			p.y += (QT_FILEICON + QT_SPACEICON) * ((al == LEFT) ? -1 : 1);
		}
		else {			
			w.DrawImage(ip.x, ip.y-2, icon);
			p.x += QT_FILEICON + QT_SPACEICON;
		}	
	}
	String fn = GetFileName(s);
	if (IsHorz()) {
		DrawFileName(w, p.x, p.y,
		             sz.cx, sz.cy, fn.ToWString(),
		             false, font, Black, LtBlue, Null, Null, false);		
	}
	else
		w.DrawText(p.x, p.y, TextAngle(), fn.ToWString(), GetStyle().font, ink);
}

Size QuickTabs::GetStdSize(Value &q)
{
	String s = q.ToString();
	Value v = GetFileName(s);
	Size sz = TabBar::GetStdSize(v);
	if (file_icons) {
		sz.cx += QT_SPACEICON + QT_FILEICON;
		sz.cy = max(sz.cy, QT_FILEICON + 4);
	}
	return sz;
}

QuickTabs& QuickTabs::FileIcons(bool b)
{
	file_icons = b;
	Repos();
	return *this;
}


void QuickTabs::Add(const char *name, bool make_active)
{
	TabBar::Add(name, ParseGroup(GetFileFolder(name)), make_active);
}

bool QuickTabs::FindSetFile(const String& fn)
{
	int i = Find(Value(fn));		
	if (i >= 0) {
		SetCursor(i);
		return true;
	}
	return false;
}

void QuickTabs::SetAddFile(const String& fn)
{
	if(IsNull(fn))
		return;
	if(FindSetFile(fn))
		return;
	Add(fn, true);
	Refresh();
}

void QuickTabs::RenameFile(const String& fn, const String& nn)
{
	int i = Find(Value(fn));		
	if (i >= 0)	TabBar::Set(i, nn, ParseGroup(GetFileFolder(nn)));
}

void QuickTabs::Set(QuickTabs& t)
{
	StringStream s;
	s.SetStoring();
	t.Serialize(s);
	s.SetLoading();
	this->Serialize(s);
	file_icons = t.file_icons;
}

