#ifndef _QuickTabs_QuickTabs_h
#define _QuickTabs_QuickTabs_h

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include "TabBar.h"

class QuickTabs : public TabBar
{
	private:
		bool file_icons;
	public:
		Callback WhenCloseRest;

		typedef QuickTabs CLASSNAME;
		QuickTabs();

		void Add(const char *name, bool make_active = false);

		QuickTabs& FileIcons(bool b = true);

		String GetFile(int n) const { return Get(n); }
		bool   FindSetFile(const String& fn);
		void   SetAddFile(const String& fn);
		void   RenameFile(const String& fn, const String& nn);
		void   Set(QuickTabs& t);
	protected:
		virtual void DrawTabData(Draw& w, Point p, const Size &sz, const Value& q, const Font &font, 
			Color ink, dword style);
		virtual Size GetStdSize(Value &q); 

		virtual void ContextMenu(Bar& bar);
		virtual void GroupMenu(Bar &bar, int n);	
};

#endif
