#include "GatoFax.h"

#define IMAGEFILE <GatoFax/GatoFax.iml>
#include <Draw/iml_source.h>

////////////////////////////////////////////////////////////////////////////////////////////////
void GatoMain::MenuExit()
{
    if ( PromptOKCancel( "Exit MyApp?" ) )
        Break();

} // END GatoMain::MenuExit()

////////////////////////////////////////////////////////////////////////////////////////////////
void GatoMain::MenuNew()
{
    PromptOK( "New fax !!!" );

} // END GatoMain::MenuNew()

////////////////////////////////////////////////////////////////////////////////////////////////
void GatoMain::FileMenu( Bar& bar )
{
    bar.Add( "New", THISBACK( MenuNew ) );
    bar.Add( "Exit", THISBACK( MenuExit ) );

} // END GatoMain::FileMenu()

////////////////////////////////////////////////////////////////////////////////////////////////
void GatoMain::MainMenu( Bar& bar )
{
    bar.Add( "File", THISBACK( FileMenu ) );

} // END GatoMain::MainMenu()

GatoMain::GatoMain()
{
    CtrlLayout( *this, "Window title" );

    AddFrame( menu );
    AddFrame( TopSeparatorFrame() );
//	AddFrame(tool);
    AddFrame( status );
    AddFrame( InsetFrame() );

    menu.Set( THISBACK( MainMenu ) );

    vSplitter.Vert().SetPos( 8000 ); //.HSizePos(10, 10).VSizePos(10,10));

    hSplitter.Horz().SetPos( 2000 );
    hSplitter << line << faxList;
    vSplitter << image << hSplitter;

    img = StreamRaster::LoadFileAny( "/home/massimo/sources/uppdev/gatofax/GatoFax/fax000000007.tif" );
    Refresh();

    image.SetImage( img );


    Sizeable().Zoomable();

}

GUI_APP_MAIN
{
    GatoMain().Run();
}

