#include <string>
#include <stdio.h>
#include <stdlib.h>

#if 0
void _____________list();
/*
 * List definitions.
 */
#define LIST_HEAD(name, type)						\
struct name {								\
	struct type *lh_first;	/* first element */			\
}

#define LIST_HEAD_INITIALIZER(head)					\
	{ NULL }

#define LIST_ENTRY(type)						\
struct {								\
	struct type *le_next;	/* next element */			\
	struct type **le_prev;	/* address of previous next element */	\
}

/*
 * List access methods
 */
#define	LIST_FIRST(head)		((head)->lh_first)
#define	LIST_END(head)			NULL
#define	LIST_EMPTY(head)		(LIST_FIRST(head) == LIST_END(head))
#define	LIST_NEXT(elm, field)		((elm)->field.le_next)

#define LIST_FOREACH(var, head, field)					\
	for((var) = LIST_FIRST(head);					\
	    (var)!= LIST_END(head);					\
	    (var) = LIST_NEXT(var, field))

/*
 * List functions.
 */
#define	LIST_INIT(head) do {						\
	LIST_FIRST(head) = LIST_END(head);				\
} while (0)

#define LIST_INSERT_AFTER(listelm, elm, field) do {			\
	if (((elm)->field.le_next = (listelm)->field.le_next) != NULL)	\
		(listelm)->field.le_next->field.le_prev =		\
		    &(elm)->field.le_next;				\
	(listelm)->field.le_next = (elm);				\
	(elm)->field.le_prev = &(listelm)->field.le_next;		\
} while (0)

#define	LIST_INSERT_BEFORE(listelm, elm, field) do {			\
	(elm)->field.le_prev = (listelm)->field.le_prev;		\
	(elm)->field.le_next = (listelm);				\
	*(listelm)->field.le_prev = (elm);				\
	(listelm)->field.le_prev = &(elm)->field.le_next;		\
} while (0)

#define LIST_INSERT_HEAD(head, elm, field) do {				\
	if (((elm)->field.le_next = (head)->lh_first) != NULL)		\
		(head)->lh_first->field.le_prev = &(elm)->field.le_next;\
	(head)->lh_first = (elm);					\
	(elm)->field.le_prev = &(head)->lh_first;			\
} while (0)

#define LIST_REMOVE(elm, field) do {					\
	if ((elm)->field.le_next != NULL)				\
		(elm)->field.le_next->field.le_prev =			\
		    (elm)->field.le_prev;				\
	*(elm)->field.le_prev = (elm)->field.le_next;			\
} while (0)

#define LIST_REPLACE(elm, elm2, field) do {				\
	if (((elm2)->field.le_next = (elm)->field.le_next) != NULL)	\
		(elm2)->field.le_next->field.le_prev =			\
		    &(elm2)->field.le_next;				\
	(elm2)->field.le_prev = (elm)->field.le_prev;			\
	*(elm2)->field.le_prev = (elm2);				\
} while (0)

LIST_HEAD(mem_list_head, mem_data);
	
struct mem_data
{
	LIST_ENTRY(mem_data) mem_list;
	int addr;
	size_t size;
	char *filename;
	int line;
};


void _____________mem_analasys();
struct mem_list_head head;
int mallocnum;

/* add to the list. */
void mem_check_malloc (int value, size_t size, char *line, int linenum)
{
	struct mem_data *pdata;

	pdata = (struct mem_data *)malloc(sizeof(struct mem_data));
	pdata->addr = value;
	pdata->size = size;
	pdata->filename = malloc(strlen(line) + 1);
	sprintf(pdata->filename, "%s", line);
	pdata->line = linenum;
	LIST_INSERT_HEAD(&head, pdata, mem_list);
	mallocnum++;
}

/* remove from the list. */
void mem_check_free (int addr, char *file, int linenum)
{
	struct mem_data *pdata;
	unsigned long index;

	index = 0;
	LIST_FOREACH(pdata, &head, mem_list) {
		if (pdata->addr == addr){
			LIST_REMOVE(pdata, mem_list);
			free(pdata->filename);
			free(pdata);
			mallocnum--;
			return;
		}
	}
}

/* for each of the not freed list. */
std::string mem_check_result(void)
{
	std::string res;
	struct mem_data *pdata;
	printf("mem_check_result(): %d\n", mallocnum);
	LIST_FOREACH(pdata, &head, mem_list) {
		res.append("line: ")
		res.append(ConvertInt.Format(pdata->line));
		res.append(pdata->filename);
		res.append('\n');
	}
	res.append("mem_check_result(): "
	res.append(ConvertInt.Format(mallocnum));

}

void mem_check_clear(void)
{
	struct mem_data *pdata, *tmp;

	for (pdata = LIST_FIRST(&head); pdata != LIST_END(&head); )
	{
		tmp = pdata;
		pdata = LIST_NEXT(pdata, mem_list);
		LIST_REMOVE(tmp, mem_list);
		free(tmp->filename);
		free(tmp);
	}
}


void _____________file_parse();

/*   Set   line   length   in   configuration   files   */     
#define   CFG_LINE 1024   
static int readline(char *line, FILE *stream)   
{   
	int flag = 1;   
	char buf[CFG_LINE];   
	unsigned int i, k = 0;   

	if (fgets(buf,   CFG_LINE,   stream)   !=   NULL) {   
		/* Delete the last '\r' or '\n' or ' ' or '\t' character */     
		for (i = strlen(buf) - 1; i >= 0; i--) {   
			if ( buf[i] == '\r' || buf[i] == '\n' || buf[i] == ' ' || buf[i] == '\t' )   
				buf[i] = '\0';   
			else
				break;   /* dap loop */   
	}

	/* Delete the front '\r' or '\n' or ' ' or '\t' character */   
	for (i = 0; i <= strlen(buf); i++) {  
		if (flag && (buf[i] == '\r' || buf[i] == '\n' || buf[i] == ' ' || buf[i] == '\t')) {
			continue;   
		}
		else{   
			flag = 0;   
			line[k++] = buf[i];   
		}   
	}   

	return   0;   
	}   
	return -1;   
}  

#define INITMALLOC 1
#define FREEMALLOC 2
typedef struct _mem_info
{
	int addr;
	int type;
}mem_info;

mem_info *mem_info_new(void)
{
	mem_info *meminfo;
	meminfo = (mem_info *)malloc(sizeof(mem_info));
	memset(meminfo, 0, sizeof(mem_info));
	return meminfo;
}

void mem_info_destroy(mem_info *meminfo)
{
	if (NULL != meminfo)
		free(meminfo);
}

/* 
  * parse the line.
  * returns: the type of memory operation, -1 if failed.
  */
int mem_line_parse(char *line, mem_info *meminfo)
{
	char *ptr = NULL, *tmp;
	if (NULL != strstr(line, "INITMALLOC"))
		meminfo->type = INITMALLOC;
	else if (NULL != strstr(line, "FREEMALLOC"))
		meminfo->type = FREEMALLOC;
	else
		return -1;

	/* get the addr. */
	if (NULL != (ptr = strstr(line, "addr")))
		tmp = strdup(ptr + 6);
	if (NULL != (ptr = strchr(tmp, ')')))
		*ptr = '\0';
	meminfo->addr = strtol(tmp, NULL, 16);
	free(tmp);
	return meminfo->type;
}

void _____________main();

std::string memchk_main(void)
{
	char line[1024];
	FILE *fd;
	int line_num, error;
	mem_info *meminfo;
	std::string res;
	
	if (NULL == (fd = fopen("log.txt", "r"))) {
		return "fopen error";
	}
	
	/* analysis every line in time. */
	for (line_num = 1; 0 == readline(line, fd); line_num++)
	{
		meminfo = mem_info_new();
		error = mem_line_parse(line, meminfo);
		if (INITMALLOC == error)
			mem_check_malloc(meminfo->addr, 10, line, line_num);
		mem_info_destroy(meminfo);
	}
	rewind(fd);
	for (line_num = 1; 0 == readline(line, fd); line_num++)
	{
		meminfo = mem_info_new();
		error = mem_line_parse(line, meminfo);
		if (FREEMALLOC == error)
			mem_check_free(meminfo->addr, line, line_num);
		mem_info_destroy(meminfo);
	}
	
	res = mem_check_result();
	mem_check_clear();
	return res;
}

#endif
