#ifndef _MDITest_MDITest_h
#define _MDITest_MDITest_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <MDITest/MDITest.lay>
#include <CtrlCore/lay.h>

#include "WindowFrame.h"

class MDIWindow : public WithWindowFrame<ParentCtrl>
{
	Size min;
public:
	virtual void Paint(Draw &w) 		{ w.DrawRect(GetSize(), SColorFace()); }
	MDIWindow() 						{ AddWindowFrame(); }
	
	virtual void SetMinSize(Size sz) 	{ min = sz; }
	virtual Size GetMinSize() const		{ return min; }
	
	virtual void Close()				{ Remove(); Ctrl::Close(); }
	virtual void TitleContext()			{ MenuBar bar; bar.Add("Close", THISBACK(Close)); bar.Execute(); }
};

class MDITest : public TopWindow {
public:
	typedef MDITest CLASSNAME;
	WithMDILayout< MDIWindow > MDIChild;
	
	MDITest();
	
	void OnMDIOK() 		{ }
	void OnMDICancel() 	{ }
};

#endif

