#ifndef _DockBars_WithMoveResize_h_
#define _DockBars_WithMoveResize_h_

//TODO: Add diagonal resize support

#include <CtrlLib/CtrlLib.h>

template <class T>
class WithMoveResize : public T {
public:
	virtual void 	MoveBegin()							{ }
	virtual void 	Moving()							{ }
	virtual void 	MoveEnd()							{ }

	enum {
		MOVE_HORZ	= -3,
		MOVE_VERT	= -2,
		MOVE		= -1,
		RESIZE_LEFT	= 0,
		RESIZE_TOP,
		RESIZE_RIGHT,
		RESIZE_BOTTOM,
		RESIZE_TOPLEFT,
		RESIZE_TOPRIGHT,
		RESIZE_BOTTOMLEFT,
		RESIZE_BOTTOMRIGHT
	};

	void StartMove(int dir = MOVE)	 	{ MoveResizeLoop().StartMoveResize(this, dir, T::GetRect(), GetMousePos()); }
	void StartResize(int dir) 			{ MoveResizeLoop().StartMoveResize(this, dir, T::GetRect(), GetMousePos()); }
	void SetMove(int dir)		 		{ sizedir = dir; }
	void EndMoveResize()		 		{ Ctrl::GetLoopCtrl()->EndLoop(); }
	
	static Image ResizeImage(int dir);	
private:	
	class MoveResizeLoop : public LocalLoop
	{
	private:
		bool IsMoving()					{ return sizedir <= MOVE; }
		Point FixMoveDir(const Point &pt)	{ return Point((sizedir == MOVE_HORZ) ? pt.x : mstart.x, (sizedir == MOVE_VERT) ? pt.y : mstart.y); }
		void DoSize(int dir,  const Point &dif, Rect &r, const Size &szmin, const Size &szmax);
		
		int sizedir;
		Rect rstart;
		Point mstart;		
		WithMoveResize<T> *wnd;
	
	public:	
		virtual void 	LeftUp(Point p, dword keyflags)									{ EndMoveResize(); }
		virtual void 	RightUp(Point p, dword keyflags)								{ EndMoveResize(); }
		virtual void 	MouseMove(Point p, dword keyflags);
		virtual Image 	CursorImage(Point p, dword keyflags);		
		
		void StartMoveResize(WithMoveResize<T> *w, int dir, const Rect &r, const Point &p);		
		void EndMoveResize();		
	};
};

template <class T>
Image WithMoveResize<T>::ResizeImage(int dir)
{
	if (dir < RESIZE_LEFT) return Image::Arrow();
	if (dir < RESIZE_TOPLEFT)
		return (dir & 1) ? Image::SizeVert() : Image::SizeHorz();
	else
		switch(dir)	{
			case RESIZE_TOPLEFT: return Image::SizeTopLeft();
			case RESIZE_TOPRIGHT: return Image::SizeTopRight();
			case RESIZE_BOTTOMLEFT: return Image::SizeBottomLeft();
			case RESIZE_BOTTOMRIGHT: return Image::SizeBottomRight();
		}		
	return Image::Arrow();
}

template <class T>
void WithMoveResize<T>::MoveResizeLoop::MouseMove(Point p, dword keyflags)
{
	Point pt = GetMousePos();
	if (wnd->GetParent())
		pt -= wnd->GetParent()->GetRect().TopLeft();			
	if (IsMoving()) {
		if (sizedir != MOVE)
			pt = FixMoveDir(pt);				
		wnd->SetRect(rstart.Offseted(pt - mstart));
		wnd->Moving();
	}
	else {
		Rect r = rstart;
		Size szmin = wnd->GetMinSize();
		Size szmax = wnd->GetMaxSize();
		Point dif = pt - mstart;
		if (sizedir <= RESIZE_BOTTOM)
			DoSize(sizedir, dif, r, szmin, szmax);
		else {
			switch(sizedir)	{
				case RESIZE_TOPLEFT:
					DoSize(RESIZE_TOP, dif, r, szmin, szmax);
					DoSize(RESIZE_LEFT, dif, r, szmin, szmax);
					break;
				case RESIZE_TOPRIGHT:
					DoSize(RESIZE_TOP, dif, r, szmin, szmax);
					DoSize(RESIZE_RIGHT, dif, r, szmin, szmax);
					break;				
				case RESIZE_BOTTOMLEFT:
					DoSize(RESIZE_BOTTOM, dif, r, szmin, szmax);
					DoSize(RESIZE_LEFT, dif, r, szmin, szmax);
					break;				
				case RESIZE_BOTTOMRIGHT:
					DoSize(RESIZE_BOTTOM, dif, r, szmin, szmax);
					DoSize(RESIZE_RIGHT, dif, r, szmin, szmax);
					break;				
			}
		}
		wnd->SetRect(r);
	}
}

template <class T>
void WithMoveResize<T>::MoveResizeLoop::DoSize(int dir, const Point &dif, Rect &r, const Size &szmin, const Size &szmax)
{
	switch (dir) {
		case RESIZE_LEFT:
			r.left = minmax(r.left + dif.x, r.right - szmax.cx, r.right - szmin.cx);
			break;
		case RESIZE_TOP:
			r.top = minmax(r.top + dif.y, r.bottom - szmax.cy, r.bottom - szmin.cy);
			break;
		case RESIZE_RIGHT:
			r.right = minmax(r.right + dif.x, r.left + szmin.cx, r.left + szmax.cx);
			break;					
		case RESIZE_BOTTOM:
			r.bottom = minmax(r.bottom + dif.y, r.top + szmin.cy, r.top + szmax.cy);
			break;					
	}	
}



template <class T>
Image WithMoveResize<T>::MoveResizeLoop::CursorImage(Point p, dword keyflags)
{
#ifdef PLATFORM_X11
	return IsMoving() ? Image::SizeAll() 
		: WithMoveResize<T>::IsResizeVert(sizedir);
#else
	return IsMoving() ? Image::Arrow() 
		: WithMoveResize<T>::ResizeImage(sizedir);
#endif
}

template <class T>
void WithMoveResize<T>::MoveResizeLoop::StartMoveResize(WithMoveResize<T> *w, int dir, const Rect &r, const Point &p)
{
	wnd = w;
	sizedir = dir;
	rstart = r;
	mstart = p;
	if (wnd->GetParent())
		mstart -= wnd->GetParent()->GetRect().TopLeft();		
	SetMaster(*wnd);
	if (sizedir < 0)
		wnd->MoveBegin();
	Run();
}

template <class T>
void WithMoveResize<T>::MoveResizeLoop::EndMoveResize()
{
	EndLoop();
	if (IsMoving()) wnd->MoveEnd();
}


#endif
