#ifndef _CtrlLibTest_CtrlLibTest_h
#define _CtrlLibTest_CtrlLibTest_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <CtrlLibTest/CtrlLibTest.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS Img
#define IMAGEFILE <CtrlLibTest/img.iml>
#include <Draw/iml_header.h>

class Tools : public TopWindow
{
public:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam) {
		if (message == WM_MOVE && GetOwner()) {
			Rect or = GetOwner()->GetScreenRect();
			Rect r = GetScreenRect();
			
			if (!or.Contains(r)) {
				Point tl = r.TopLeft();
				Point br = r.BottomRight();
				if (tl.x < or.left)
					r.OffsetHorz(or.left - tl.x);	
				if (tl.y < or.top)
					r.OffsetVert(or.top - tl.y);	
				if (br.x > or.bottom)
					r.OffsetHorz(br.x - or.bottom);	
				if (br.y > or.right)
					r.OffsetVert(br.y - or.right);	
				SetRect(r);				
			}
		}
		return TopWindow::WindowProc(message, wParam, lParam);
	}
};

class CtrlLibTest : public WithCtrlLibTestLayout<TopWindow> {
public:
	typedef CtrlLibTest CLASSNAME;
	ImageBuffer ib;
	Image img;
	
	
	CtrlLibTest();
};

#endif

