#include "CtrlLibTest.h"

#define IMAGECLASS Img
#define IMAGEFILE <CtrlLibTest/img.iml>
#include <Draw/iml_source.h>

// Container class to automate scrolling
class ScrollContainer : public ParentCtrl
{
private:
	ScrollBars 	scrollbars;
	Point 		psb;
	Ptr<Ctrl>	pane;

	virtual void 		Layout();
	virtual void 		ChildRemoved(Ctrl *child) { if (child == pane) Clear(); }
	void 		 		Scroll();
public:
	typedef	ScrollContainer CLASSNAME;

	ScrollContainer &	Set(Ctrl &p, Size sz = Null);
	Ctrl *				Get() const 		{ return pane; }
	void 				Clear();
	
	ScrollContainer();
};

void ScrollContainer::Layout()
{
	if (pane) {
		scrollbars.SetPage(scrollbars.GetReducedViewSize());
		scrollbars.SetTotal(pane->GetSize());
	}
}

void ScrollContainer::Scroll()
{
	Point newpos = scrollbars;
	pane->SetRect(pane->GetRect().Offseted(psb-newpos));
	psb = newpos;	
}

ScrollContainer & ScrollContainer::Set(Ctrl &p, Size sz)
{
	if (IsNull(sz))
		sz = p.GetMinSize();
	p.SetRect(0, 0, sz.cx, sz.cy);
	pane = &p;
	Add(p);
	Layout();
	return *this;
}

void ScrollContainer::Clear()
{
	if (pane && pane->GetParent() == this)
		pane->Remove();
	pane = NULL;
	psb = Point(0, 0);
	scrollbars.SetX(0, 0, 0);
	scrollbars.SetY(0, 0, 0);
}

ScrollContainer::ScrollContainer()
{
	Clear();
	scrollbars.WhenScroll = THISBACK(Scroll);
	AddFrame(scrollbars.AutoHide(true));	
}

// LayoutCtrl : Required because ParenetCtrl doesn't have SetMinSize
class LayoutCtrl : public ParentCtrl
{
public:
	virtual void SetMinSize(Size sz)	{ minsize = sz; }
	virtual Size GetMinSize() const		{ return IsNull(minsize) ? Ctrl::GetMinSize() : minsize; }

	LayoutCtrl()						{ minsize = Null; }
private:
	Size minsize;
};

// Our Tab Window
class TabScrollTest : public TopWindow {
public:
	typedef TabScrollTest CLASSNAME;
	WithCtrlLibTestLayout<LayoutCtrl> 	pane;
	ScrollContainer						container;
	TabCtrl 							tabs;

	TabScrollTest();
	
	void ContainerScroll();
};


TabScrollTest::TabScrollTest()
{
	CtrlLayout(pane);
	tabs.Add(container.Set(pane).SizePos(), "ScrollContainer");
	Add(tabs.SizePos());
	Sizeable();
}

// Run
GUI_APP_MAIN
{
	TabScrollTest wnd;
	wnd.SetRect(100, 100, 500, 200);
	wnd.Run();
}
