#ifndef _CtrlLibTest_CtrlLibTest_h
#define _CtrlLibTest_CtrlLibTest_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <CtrlLibTest/CtrlLibTest.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS Img
#define IMAGEFILE <CtrlLibTest/img.iml>
#include <Draw/iml_header.h>

class Tools : public TopWindow
{
public:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam) {
		if (message == WM_MOVE && GetOwner()) {
			Rect or = GetOwner()->GetScreenRect();
			Rect r = GetScreenRect();
			
			if (!or.Contains(r)) {
				Point tl = r.TopLeft();
				Point br = r.BottomRight();
				if (tl.x < or.left)
					r.OffsetHorz(or.left - tl.x);	
				if (tl.y < or.top)
					r.OffsetVert(or.top - tl.y);	
				if (br.x > or.bottom)
					r.OffsetHorz(br.x - or.bottom);	
				if (br.y > or.right)
					r.OffsetVert(br.y - or.right);	
				SetRect(r);				
			}
		}
		return TopWindow::WindowProc(message, wParam, lParam);
	}
};

class DropButton : public WithDropChoice<Button> {
	public:
		virtual void  SetData(const Value& v) 	{ data = v; }
		virtual Value GetData() const		  	{ return data; }
	private:
		Value data;
};

class CtrlLibTest : public WithCtrlLibTestLayout<TopWindow> {
public:
	typedef CtrlLibTest CLASSNAME;
	DropButton drop;
	MultiButton::Style st;
	
	CtrlLibTest() {
		Sizeable();
		CtrlLayout(*this);
	
		st = MultiButton::StyleFrame();
		st.margin = Rect(0, 0, 0, 0);
		st.border = 0;
		drop.SetStyle(st);
	
		for (int i = 0; i < 10; i++)
			drop.AddList(AsString(i));
		drop.SetData("0");
		drop.WhenSelect = THISBACK(OnSelect);
	}
		
	void OnSelect() {
		String s = ~drop;	
		drop.SetLabel(Format("Split %s", s));
	}
};

#endif

